require 'active_support/time'

module DateUtility

  #format=%Y-%m-%d"
  #format="%b %d, %Y"  JAN 10, 2014
  #format="%m/%d/%Y"    01/10/2014

  def getFormatedDateStr(dateStr, fromFormatStr, toFormatStr)
    #dateObj = DateTime.strptime(dateStr, format="%Y-%m-%d %H:%M:%S %Z")
    dateObj = DateTime.strptime(dateStr, format=fromFormatStr)
    return dateObj.strftime(toFormatStr).to_s
  end

  def getDateNthDaysAgo(numberOfDaysAgo, formatStr)
    dateNthDaysAgo = numberOfDaysAgo.day.ago.strftime(format=formatStr)

    return dateNthDaysAgo
  end

  def getDateNthDaysFromNow(numberOfDaysFromNow, formatStr)
    dateNthDaysFromNow = numberOfDaysFromNow.day.from_now.strftime(format=formatStr)
    return dateNthDaysFromNow
  end

  def getDateNthMonthsFromNow(numberOfMonthFromNow, formatStr)
    dateNthMonthFromNow = numberOfMonthFromNow.month.from_now.strftime(format=formatStr)
    return dateNthMonthFromNow
  end

  def getNthMinFromNow(numberOfMinFromNow)
    dateTimeNthHours = numberOfMinFromNow.minute.from_now.strftime(format="%I:%M %p")

    return dateTimeNthHours.to_s
  end

  def getNthHoursFromNow(numberOfHoursFromNow)
    dateTimeNthHours = numberOfHoursFromNow.hour.from_now.strftime(format="%I:%M %p")
    puts "Nth Hours from now: " + dateTimeNthHours.to_s

    return dateTimeNthHours.to_s
  end

  def getDateNthYearsFromNow(numberOfYearsFromNow, formatStr)
    dateStr = numberOfYearsFromNow.year.from_now.strftime(format=formatStr)
    #puts ("[getDateNthYearsFromNow() ]" + dateStr)

    return dateStr
  end

  def getNthMonthFromGivenDate(dateStr, nthMonth)
    dateStrArray = dateStr.split("/")
    time = Time.parse(dateStrArray[2] + '-' + dateStrArray[0] + '-' + dateStrArray[1] + ' 09:00 AM')
    nthMonthLater = time + nthMonth.month

    return nthMonthLater.strftime("%B %Y")
  end

  def getDateNthDaysFromGivenDate(dateStr, nthDay)
    dateStrArray = dateStr.split("/")
    time = Time.parse(dateStrArray[2] + '-' + dateStrArray[0] + '-' + dateStrArray[1] + ' 09:00 AM')
    nthMonthLater = time + nthDay.day

    return nthMonthLater.strftime("%m/%d/%Y")
  end

  def getNThYearFromGivenDate(dateStr, nthYear)
    dateStrArray = dateStr.split("/")
    time = Time.parse(dateStrArray[2] + '-' + dateStrArray[0] + '-' + dateStrArray[1] + ' 09:00 AM')
    nthYearLater = time + nthYear.year

    return nthYearLater.strftime("%Y")
  end

  def getDateNthYearsAgo(numberOfYearsAgo, formatStr)
    dateNthYearsAgo = numberOfYearsAgo.year.ago.strftime(format=formatStr)
    return dateNthYearsAgo
  end

  def getDayofWeek(dateStr)
    dateStrArray = dateStr.split("/")
    time = Time.parse(dateStrArray[2] + '-' + dateStrArray[0] + '-' + dateStrArray[1] + ' 09:00 AM')
    puts "time=" + time.to_s
    return time.strftime("%A")
  end

  def getMonthOfYear(dateStr, format)
    dateStrArray = dateStr.split("/")
    time = Time.parse(dateStrArray[2] + '-' + dateStrArray[0] + '-' + dateStrArray[1] + ' 09:00 AM')
    puts "time=" + time.to_s
    return time.strftime(format)
  end

  def getYear(dateStr)
    dateStrArray = dateStr.split("/")
    return dateStrArray[2]
  end

  def getDay(dateStr)
    dateStrArray = dateStr.split("/")
    return dateStrArray[1]
  end

  def getFormatedDateStr(dateStr, fromFormatStr, toFormatStr)
    #dateObj = DateTime.strptime(dateStr, format="%Y-%m-%d %H:%M:%S %Z")
    dateObj = DateTime.strptime(dateStr, format=fromFormatStr)
    return dateObj.strftime(toFormatStr).to_s
  end

  def convertTimeNowToUTCDate()
    t = Time.now.utc.strftime("%m/%d/%Y")
    return t.to_s
  end

  def isDateFormatValid?(dateStr, formatStr)
    #puts "!!!Date String is " + dateStr
    begin
      dateObj = DateTime.strptime(dateStr, format=formatStr)
      #puts "[isDateFormatValid?] Date is " + dateObj.to_s

      return true
    rescue Exception=>e
      return false
    end
  end

end